// 3D Multimedia Studio - Multi Level Carousel 1
// RimV: www.mymedia-art.com || trieuduchien@gmail.com 
// Please read documentation before customizing

package {
	
	// Tweener, Flash class and Greate White Papervision3D 2.0
	import caurina.transitions.*;
	
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	import flash.text.*;
	import flash.utils.Dictionary;
	
	import org.papervision3d.*;
	import org.papervision3d.cameras.FreeCamera3D;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	//_________________________________________________ Main class
	
	public class multiLevelCarousel1 extends Sprite
	{
		
		//------------------------ PARAMETERS -----------------------//
		// Tweening parameters, more Tweener information at:
		// http://hosted.zeh.com.br/tweener/docs/en-us/
		private var cameraTweenTime:Number = 2;
		private var cameraTweenEasing:String = "easeOutQuint";
		private var zoomTweenTime:Number = 1;
		private var zoomTweenEasing:String = "easeOutQuint";
		private var captionTweenTime:Number = 1;
		private var captionTweenEasing:String = "easeOutQuint";
		private var thumbnailTweenTime:Number = 2;
		private var thumbnailTweenEasing:String = "easeOutQuint";
		private var descriptionTweenTime:Number = 1;
		private var descriptionTweenEasing:String = "easeOutQuint";
		
		// Carousel Radius
		private var carouselRadius:Number = 450;
		private var itemsPerLevel:Number = 15;
		private var levels:Number = 2;
		private var carouselDeltaHeight:Number = 200;
		
		// Zoom rate
		private var zoomRate:Number = 200;
		
		// Transparency
		private var transparent:Boolean = false;
		
		// Caption Blur Tweening
		private var captionBlurX:Number = 30;
		private var captionBlurY:Number = 30;
		
		// Reflection
		private var reflection:Boolean = true; // turn on/off reflection
		private var refDist:Number = 130;  	//Distance from image to its corresponding reflection
		private var refIn1:Number = 0.5;	// Reflection Intensity 1
		private var refIn2:Number = 0;		// Reflection Intensity 2
		private var refDen1:Number = 0;		// Reflection Density 1
		private var refDen2:Number = 180;	// Reflection Density 2
		private var refSmooth:Boolean = false;	// Smooth Reflection
		private var refDoubleSide:Boolean = false;	// 2 side Reflection
		
		// Cover Effect
		private var coverAlpha:Number = .3;
		
		// Thumbnail Area
		private var thumbnailSize:Number = 90;
		
		// Link
		private var useLink:Boolean = true;
		private var openType:String = "_blank";
		
		// Click to Activate Alpha value
		private var cAlpha:Number = .8;
		
		// XML/CSS path
		private var xml_path:String = "multiLevelCarousel1.xml";	// XML path
		private var css_path:String = "css/styles.css" // CSS path
		
		// Camera property
		private var cameraRadius:Number = 800;
		private var cameraY:Number = 200;
		private var cameraZ:Number = -800;	
		private var cameraFront:Number = 150;
		
		// Plane property
		private var planeDoubleSide:Boolean = false;
		private var planeSmooth:Boolean = false;
		private var quality:Number = 1;
		
		//--------------- end of -- PARAMETERS -----------------------//
		
		
		//------------------------ 3D VARS --------------------------//
		
		private var scene:Scene3D = new Scene3D();
		private var camera:FreeCamera3D = new FreeCamera3D();
		private var cameraZoom:Number = 5;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine = new BasicRenderEngine();
		
		//--------------- end of -- 3D VARS -----------------------//
		
		
		//------------------------ XML VARS --------------------------//
		
		private var xmlLoader:URLLoader = new URLLoader();
		private	var xmlData:XML = new XML();
		
		//--------------- end of -- XML VARS -----------------------//
		
		
		//------------------------ GENERAL DATA --------------------------//
		
		private var TOTAL:Number; 	// Number of images/videos/mp3s
		private var thumb:Array = new Array();
		private var small:Array = new Array();
		private var capt:Array = new Array();
		private var desc:Array = new Array();
		private var link:Array = new Array();
		private var large:Array = new Array();
		private var loaded:Array = new Array();
		private var largeItem:Array = new Array();
			
		
		// Camera Infor
		private var COB:Object = new Object();
		private var camPos:Object = new Object();
				
		//--------------- end of -- GENERAL DATA -----------------------// 
			
		
		//------------------------ MISC VARS -----------------------//
		
		private var cID:Number = 0;	// Current pressed plane ID
		private var lID:Number = 0;
		private var pInfor:Dictionary = new Dictionary();
		private var pInfor2:Dictionary = new Dictionary();
		private var currentPlane:Cube = null;
		private var lastPlane:Cube;
		private var currentItem:Number = -1;
		private var lastItem:Number = -1;
		private var count0:Number = 0;
		private var count:Number = 0;
		private var reached:Boolean = false;
		private var lastReached:Boolean = true;
		private var cameraReached:Boolean = false;
		private var loading:Boolean = false;
		private var refTemp:Plane;
		private var rollOver:Boolean = false;
		private var rollOverBar:Boolean = false;
		private var rollOverLeft:Boolean = false;
		private var rollOverRight:Boolean = false;
		private var cameraAngle:Number;
		private var delta:Number;
		private var thumbnailLength:Number;
		private var thumbnailDistance:Number;
		private var thumbnailNum:Number;
		private var thumbnailMove:Number;
		private var thumbnailStep:Number;
		private var step:Number = 0;
		private var navigationMode:Boolean = true;
		private var bytesLoaded:Number = 0;
		private var bytesTotal:Number = 1;
		private var currentLoader:Loader = new Loader();
		private var thumbnailOrigin:Number;
		private var remain:Number = 0;
		private var angle:Number = 0;
		private var mouseX0:Number;
		private var mouseY0:Number;
		private var cameraX0:Number;
		private var cameraY0:Number;
		private var css:StyleSheet = new StyleSheet(); // StyleSheet
		//sliding limit, these 2 values indicate the range of scrubber
		private var sl1:Number = 41; 
		private var sl2:Number = 406;
		private var hotSpot:DisplayObject3D = new DisplayObject3D();
		private var zoomMode:Boolean = false;
				
		//--------------end of --- MISC VARS -----------------------//
		
							
				
		//___________________________________________________ CONSTRUCTOR: Intial 3D and Start creating 3D Wall
		
		public function multiLevelCarousel1()
		{
			// Initial 3d environment
			Initial3D();
			
			// Create 3D Wall
			createMultiLevelCarousel1();	
		}
		
		// Inital 3D
		private function Initial3D():void
		{
			// Align , scale Stage to full fill screen
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			// Reposition element if stage is resized
			stage.addEventListener(	Event.RESIZE, rePosition)
					
			// temporary removing, solve z index
			removeChild(caption);
			removeChild(thumbnailBack);
			removeChild(thumbnailNav);
			removeChild(clickToActive);
			removeChild(preloader);
			
			// Viewport
			viewport = new Viewport3D(stage.stageWidth, stage.stageHeight, true, true);
			viewport.visible = false;
			addChild(viewport);
			
			// display and setup necessary components
			addChild(caption);
			addChild(clickToActive);
			addChild(thumbnailBack);
			addChild(thumbnailNav);
			addChild(preloader);
			clickToActive.alpha = 0;
			clickToActive.x = 99999;
												
			// Camera 3D
			camera.zoom = cameraZoom;
			camera.z = cameraZ;
			camera.y = cameraY;
			 
			// init Stylesheet
			initStyleSheet();
			
			// setup caption blur filter
			//var filter:BlurFilter = new BlurFilter(0, 0, BitmapFilterQuality.LOW);
			//caption.filters = [filter];
			
			/// setup preloader
			viewport.alpha = 0;
			caption.visible = false;
			preloader.x = (stage.stageWidth - preloader.width) * .5 ;
			preloader.y = (stage.stageHeight - preloader.height) * .5 ;
			preloader.process.scaleX = 0;
			
			// Position of components
			// Thumbnail area
			thumbnailOrigin = thumbnailNav.width;
			thumbnailNav.x = (stage.stageWidth - thumbnailOrigin) * .5;
			thumbnailNav.y = thumbnailBack.y = stage.stageHeight + 1000;
			thumbnailBack.width = stage.stageWidth;
			
			// camera follows hotspot
			hotSpot.x = hotSpot.y = hotSpot.z = 0;
			
			// setup thumbnail area
			setUpThumbnailArea();
			
			// setup mode button
			setUpModeButton();
			
		}
		
		// Start building 
		private function createMultiLevelCarousel1():void 
		{
			// Load data from XML
			xmlLoading();
			
			// Render
			this.addEventListener(Event.ENTER_FRAME, update3D);
		}
		
		//__________________________________________________________ LOAD XML
		
		private function xmlLoading():void
		{
			xmlLoader.addEventListener(Event.COMPLETE, LoadXML);
			xmlLoader.load(new URLRequest( xml_path ));
		}
		
		private function LoadXML(e:Event):void
		{
			//Extract data
			xmlData = new XML(e.target.data);
			ParseData(xmlData);	
		}
		
		private function ParseData(dat:XML):void
		{
			//Number of photos
			TOTAL = dat.items.item.length();
			
			// Add Enterframe event for preloader
			preloader.addEventListener(Event.ENTER_FRAME, preload);
						
			for (var i:uint = 0; i < TOTAL; i++)
			{
				small[i] = new Object();
				small[i].position = thumbnailNav.controlLeft.width + i * (thumbnailDistance +  thumbnailSize) + thumbnailDistance;
				small[i].src = dat.items.item.small.attributes()[i];
				thumb[i] = dat.items.item.thumbnail.attributes()[i];
				capt[i] = dat.items.item.caption.attributes()[i];
				desc[i] = dat.items.item.description.text()[i];
				large[i] = dat.items.item.full.attributes()[i];
				link[i] = dat.items.item.link.attributes()[i];
				loaded[i] = false;
			}
			// load small thumbnail
			loadSmallThumbnail();
			//Load thumbnail
			loadThumbnail();
			
		}
			
		//__________________________________________________________ LOAD EXTERNAL ASSET
		
		// Small thumbnails in control area
		private function loadSmallThumbnail():void
		{
			for (var i:uint = 0; i < TOTAL; i++)
			{
				var myLoader:Loader = new Loader();
				var myRequest:URLRequest = new URLRequest(small[i].src);
				myLoader.load(myRequest);
				myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, smallThumbnailLoaded);
				pInfor2[myLoader] = i;
			}
		}
		
		// Thumbnail in navigation mode
		private function loadThumbnail():void
		{
			for (var i:uint = 0; i < TOTAL; i++)
			{
				var myLoader:Loader = new Loader();
				var myRequest:URLRequest = new URLRequest(thumb[i]);
				myLoader.load(myRequest);
				myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, thumbnailLoaded);
				pInfor[myLoader] = i;
			}
		}
		
		//__________________________________________________________ SMALL THUMBNAIL LOADED, ADD TO CONTROL AREA
		
		private function smallThumbnailLoaded(e:Event):void
		{
			// retrieve small thumbnail
			var loadedObject:Loader = e.target.loader;
			var index = pInfor2[loadedObject];
			
			// retrieve thumbnail area
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			
			// Create new movie clip to contain bitmap thumbnail
			var myThumb:MovieClip = new MovieClip();
			// Add Cover Effect
			var myCover:thumbnailCover = new thumbnailCover();
			myCover.gotoAndStop(1);
			myCover.width = loadedObject.width;
			myCover.height = loadedObject.height;
			myCover.alpha = coverAlpha;
			myCover.x = myCover.width / 2; 
			myCover.y = myCover.height / 2;
			// Save index for later reference
			myCover.index= index;
			// add to myThumb container
			myThumb.addChild(loadedObject);
			myThumb.addChild(myCover);
			// finally add to control area
			area.addChild(myThumb);
			// calculate new position based on width and height
			var temp:Number = (loadedObject.width < thumbnailSize) ? ((thumbnailSize - loadedObject.width) / 2) : 0;
			small[index].position += temp; 
			myThumb.x = small[index].position;
			myThumb.y = (area.height - myThumb.height) / 2;
			
			// Add Small Thumbnail Interactive
			myThumb.addEventListener(MouseEvent.MOUSE_DOWN, thumbnailPress);
					
			if (++count0 == TOTAL) 
			{
				if (TOTAL % thumbnailNum != 0) 
					thumbnailStep = Math.floor(TOTAL / thumbnailNum) + 1;
				else 
					thumbnailStep = TOTAL / thumbnailNum;
				remain = (6 - TOTAL % 6);
				if (remain != 6) remain = remain * (thumbnailDistance +  thumbnailSize); else remain = 0;
				addThumbnailAreaInteractive();
			}
		}
		
		//__________________________________________________________ SMALL THUMBNAIL PRESS, ROLL OVER, ROLL OUT
		
		private function thumbnailPress(e:Event):void
		{
			if (!loading)
			{
				var index:Number = e.target.parent.index;
				lastItem = currentItem;
				currentItem = index;
				
				// fade out last item
				if (lastItem != -1)
				Tweener.addTween(largeItem[lastItem],	{	alpha:0,
															time:1,
															onComplete:function():void
															{
																largeItem[lastItem].visible = false;	
															}
														}
												);
												
				if (!loaded[index])
				{
					// assign currentPlane
					currentPlane = scene.getChildByName("plane" + index) as Cube;
					lID = index;
					loading = true;
					// display preloader
					preloader.process.scaleX = 0;
					bytesLoaded = 0;
					bytesTotal = 1;
					addChild(preloader);
					Tweener.addTween(preloader,{alpha:1, time:0.5});
					preloader.addEventListener(Event.ENTER_FRAME, preloadLarge);
					// Load large version
					var myRequest:URLRequest = new URLRequest(large[index]);
					var myLoader:Loader = new Loader();
					myLoader.load(myRequest);
					myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, largeVersionLoaded);
					myLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadingLargeVersion);
				}
				else
				{
					largeItem[currentItem].x = (stage.stageWidth - largeItem[currentItem].width) / 2;
					largeItem[currentItem].y = (stage.stageHeight - largeItem[currentItem].height) / 2;
					largeItem[currentItem].visible = true;
					Tweener.addTween(largeItem[currentItem],	{	alpha:1,
																	time:1
																}
														);
				}
			}
		}
		
		//__________________________________________________________ THUMBNAIL LOADED, CREATE PLANE
		
		private function thumbnailLoaded(e:Event):void
		{
			// retrieve thumbnail
			var loadedObject:Loader = e.target.loader;
			
			// Bitmapdata
			var bmpData:BitmapData = new BitmapData( loadedObject.width, loadedObject.height, transparent, 0x000000 );
			bmpData.draw(loadedObject);
			
			//Bitmap Material
			var bitmapMaterial:BitmapMaterial = new BitmapMaterial(bmpData);
			bitmapMaterial.name = "material";
			bitmapMaterial.precise = false;
			bitmapMaterial.interactive = true;
			bitmapMaterial.doubleSided = planeDoubleSide;
			bitmapMaterial.smooth = planeSmooth;
						
			// Materials
			var materials:MaterialsList = new MaterialsList(
			{
				back:  new MovieAssetMaterial( "BACK", true ),
				front: bitmapMaterial
			} );
			
			var insideFaces: int = Cube.FRONT + Cube.BACK;
	
			// Create a plane or cube with depth = 1 with 2 faces
			var p:Cube= new Cube( materials, loadedObject.width, 1, loadedObject.height, quality, 1, quality, insideFaces );
						
			//retrieve index
			var index:Number = pInfor[loadedObject];
					
			// add to scene
			scene.addChild( p, "plane" + index );
			
			// data embeded in each plane
			p.extra = {
				index:new Number,
				width:new Number,
				height:new Number,
				x:new Number,
				y:new Number,
				z:new Number
			}
			
			// save index for later reference
			p.extra.index = index;
			
			// width and height of thumbnail 
			p.extra.width = loadedObject.width;
			p.extra.height = loadedObject.height;
			p.visible = false;
								
									
			//______________________________________________________________ REFLECTION
			
			if (reflection) 
			{
				// save reflection for later use
				p.extra.reflection = new Plane();
				
				// Create new reflection Bitmap Data 
				var bitmapData2:BitmapData = new BitmapData( loadedObject.width, loadedObject.height, true, 0x000000);
				
				// Flip vertical
				var m:Matrix = new Matrix();
				m.createBox(1, -1, 0, 0, loadedObject.height);
				bitmapData2.draw( bmpData, m );
				
				//Reflection Bitmap Object
				var b2:Bitmap = new Bitmap(bitmapData2);
				
				// Reflection mask
				m.createGradientBox(loadedObject.width, loadedObject.height,Math.PI/2,loadedObject.height);
				var mymask:Shape = new Shape();
				mymask.graphics.lineStyle(0,0,0);
				mymask.graphics.beginGradientFill("linear", [0x000000, 0x000000],[refIn1, refIn2], [refDen1, refDen2],m) ;
				mymask.graphics.lineTo(0, loadedObject.height);
				mymask.graphics.lineTo(loadedObject.width, loadedObject.height);
				mymask.graphics.lineTo(loadedObject.width, 0)
				mymask.graphics.lineTo(0, 0)
				mymask.graphics.endFill();
				
				// CacheaAsBitmap
				mymask.cacheAsBitmap = true;
				b2.cacheAsBitmap = true;
				
				// Create mask
				b2.mask = mymask;
				
				addChild(b2);
				addChild(mymask);
				
				var bmp3:BitmapData = new BitmapData(loadedObject.width, loadedObject.height, true, 0x000000);
				bmp3.draw(b2);
				
				// Create Reflection plane
				var bm2:BitmapMaterial = new BitmapMaterial(bmp3);
				bm2.precise = false;
				bm2.doubleSided = refDoubleSide;
				bm2.smooth = refSmooth;
				var p2:Plane = new Plane(bm2, 1, 0, 1, 1);
				p.extra.reflection = p2;
				removeChild(b2);
				removeChild(mymask);
			}
						
			// Interactive Roll Over, Roll Out, Press/Release
			p.addEventListener( InteractiveScene3DEvent.OBJECT_RELEASE, onPlaneRelease, false, 0, true );
			p.addEventListener( InteractiveScene3DEvent.OBJECT_OVER, onPlaneRollOver, false, 0, true );
			p.addEventListener( InteractiveScene3DEvent.OBJECT_OUT, onPlaneRollOut, false, 0, true );
								
			// Finish loading, add interactive
			if (++count == TOTAL)
			{
				distributePlane();
				setupMouseWheel();
				setupStageMouseDown();
			}
		}
		
		private function distributePlane():void
		{
			// ditribute in circle orientation
			var anglePer:Number = (360 / itemsPerLevel) * Math.PI/180;
			var k:Number = 0;
					
			for (var i0:Number = 0; i0 < levels; i0++)
			{ 
				for (var i:uint = 0; i < itemsPerLevel; i++)
				{
					var p:Cube = scene.getChildByName("plane" + k++) as Cube;
					p.visible = true;
					p.x = Math.cos( i * anglePer) * carouselRadius;
					p.z = Math.sin( i * anglePer) * carouselRadius;
					p.y = i0 * carouselDeltaHeight;
					p.rotationY = ( -i * anglePer) * (180/Math.PI) + 270;
					p.moveForward(-cameraFront);
					p.extra.x = p.x;
					p.extra.y = p.y;
					p.extra.z = p.z;
					p.moveBackward(-cameraFront);
				}
				
				// distribute reflection
				if (reflection && i0 == 0)
				for (var j:uint = 0; j < itemsPerLevel; j++)
				{
					var pl:Cube = scene.getChildByName("plane" + j) as Cube;
					scene.addChild(pl.extra.reflection);
					pl.extra.reflection.rotationY = pl.rotationY;
					pl.extra.reflection.x = pl.x;
					pl.extra.reflection.z = pl.z;
					pl.extra.reflection.y = -refDist + pl.y;
				}			
			}
			
		}
		
		//__________________________________________________________ MOUSE ROLL OVER PLANE, ADD INTERACTIVE 
		
		private function onPlaneRollOver(e:InteractiveScene3DEvent):void
		{
			buttonMode = true;
			// to check if click outside
			rollOver = true;
			// apply text
			caption.text.text = capt[e.target.extra.index];
			// move caption to mouse position
			Tweener.addTween(caption,	{	x:stage.mouseX + 10,
											y:stage.mouseY + 10,
											//_blur_blurX:0,
											//_blur_blurY:0,
											alpha:1,
											time:captionTweenTime,
											transition:captionTweenEasing
										}
								);
			// add mouse move interactive
			this.addEventListener(MouseEvent.MOUSE_MOVE, captionMouseMove);
			
			// display clickToActive
			if (loaded[e.target.extra.index] && cameraReached && e.target == currentPlane) 
			{
				clickToActive.x = (stage.stageWidth - clickToActive.width) * .5;
				clickToActive.y = (stage.stageHeight - clickToActive.height) * .5;
				Tweener.addTween(clickToActive,{	alpha:cAlpha,
													time:1
												}
											);	
			}
		}
		
		//__________________________________________________________ MOUSE ROLL OUT PLANE, ADD INTERACTIVE
		
		private function onPlaneRollOut(e:InteractiveScene3DEvent):void
		{
			buttonMode = false;
			// to check if click outside
			rollOver = false;
			// fade out caption
			Tweener.addTween(caption,	{	//_blur_blurX:captionBlurX,
											//_blur_blurY:captionBlurY,
											alpha:0,
											time:captionTweenTime,
											transition:captionTweenEasing
										}
								);
			// remove mouse move interactive
			this.removeEventListener(MouseEvent.MOUSE_MOVE, captionMouseMove);
			
			// hide clickToActive
			Tweener.addTween(clickToActive,{	alpha:0,
												time:1,
												onComplete:function():void
												{
													clickToActive.x = 99999;
												}
											}
										);
		}
		
		// caption follow mouse with easing
		private function captionMouseMove(e:Event):void
		{
			Tweener.addTween(caption,	{	x: stage.mouseX + 10,
											y: stage.mouseY + 10,
											time:0.5
										}
							);
		}
		
		//_________________________________________________________ MOUSE RELEASE PLANE, ADD INTERACTIVE
		
		private function onPlaneRelease(e:InteractiveScene3DEvent):void
		{
			if (!loading)
			{
				// gallery or navigate mode 
				if (currentPlane != e.target)
				{
					zoomMode = true;
					this.removeEventListener(Event.ENTER_FRAME, update3D);
									
					Tweener.removeTweens(camera);
												
					// retrieve clicked plane
					var p:Cube = e.target as Cube;
									
					// assign current plane to new one for further tracking
					currentPlane = p;
									
					// Tween camera to target
					lastReached = reached; 
					reached = false;
					cameraReached = false;
																		
					Tweener.addTween(camera, {	x: p.extra.x,
												y: p.extra.y,
												z: p.extra.z,
												time: cameraTweenTime,
												transition: cameraTweenEasing,
												
												// Rendering scene on tweening update
												onUpdate:function():void
												{
													camera.lookAt(hotSpot);
													// Render 3D
													renderer.renderScene(scene, camera, viewport);
												},
												
												// Load full version when tweening is completed
												onComplete:function():void
												{
													cameraReached = true;
													if (!loaded[currentPlane.extra.index])
														if (lastReached || (p.extra.index == currentPlane.extra.index))
														{
															// display preloader
															preloader.process.scaleX = 0;
															bytesLoaded = 0;
															bytesTotal = 1;
															loading = true;
															addChild(preloader);
															Tweener.addTween(preloader,{alpha:1, time:0.5});
															preloader.addEventListener(Event.ENTER_FRAME, preloadLarge);
															// Load large version
															var myRequest:URLRequest = new URLRequest(large[currentPlane.extra.index]);
															var myLoader:Loader = new Loader();
															myLoader.load(myRequest);
															myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, largeVersionLoaded);
															myLoader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadingLargeVersion);
															currentLoader = myLoader;
															lID = currentPlane.extra.index;
														}
												}
											}
										);
				
				Tweener.addTween(hotSpot,{	x:p.x,
											y:p.y,
											z:p.z,
											time: cameraTweenTime,
											transition: cameraTweenEasing,
											// Rendering scene on tweening update
											onUpdate:function():void
											{
												camera.lookAt(hotSpot);
												// Render 3D
												renderer.renderScene(scene, camera, viewport);
											}
										});
				}
				else
				if (loaded[e.target.extra.index])
				{
					if (navigationMode) 
					{
						currentItem = e.target.extra.index;
						displayGalleryMode(currentItem);
					}
				}
			}
		}
		
		// update plane to full image with height resolution
		private function largeVersionLoaded(e:Event):void
		{
			var index:Number = currentPlane.extra.index;
			var largeVersion:Loader = e.target.loader;
			
			if (lID == index)
			{
				loading = false;
				preloader.removeEventListener(Event.ENTER_FRAME, preloadLarge);
				
				// hide preloader
				Tweener.addTween(preloader,{alpha:0, time:0.5, onComplete:function():void {removeChild(preloader)}});
				loaded[index] = true;
				largeItem[index] = largeVersion;
				reached = true;
				
				// Bitmap data copied from Loader object
				var bmpData:BitmapData = new BitmapData( largeVersion.width, largeVersion.height, transparent, 0x000000 );
				bmpData.draw(largeVersion);
				
				//Bitmap Material
				var bitmapMaterial:BitmapMaterial = new BitmapMaterial(bmpData);
				bitmapMaterial.precise = false;
				bitmapMaterial.interactive = true;
				bitmapMaterial.doubleSided = planeDoubleSide;
				bitmapMaterial.smooth = planeSmooth;
				
				// Materials
				var materials:MaterialsList = new MaterialsList(
				{
					back:  new MovieAssetMaterial( "BACK", true ),
					front: bitmapMaterial
				} );
				
				var insideFaces: int = Cube.FRONT + Cube.BACK;
		
				// Create a plane or cube with depth = 1 with 2 faces
				
				var p:Cube= new Cube( materials, currentPlane.extra.width, 1, currentPlane.extra.height, quality, 1, quality, insideFaces );
							
				// Replace current plane with the new one
				p.copyTransform(currentPlane);
				
				p.extra = {
					index:new Number,
					x:new Number,
					y:new Number,
					z:new Number
				}
								
				// save index for later reference
				p.extra.index = index;
				p.rotationY = currentPlane.rotationY;
				p.extra.x = currentPlane.extra.x;
				p.extra.y = currentPlane.extra.y;
				p.extra.z = currentPlane.extra.z;
							
				// reflection
				if (currentPlane.extra.reflection != null) p.extra.reflection = currentPlane.extra.reflection;
				
				// remove small plane
				scene.removeChild(currentPlane);
				currentPlane.removeEventListener( InteractiveScene3DEvent.OBJECT_RELEASE, onPlaneRelease );
				currentPlane.removeEventListener( InteractiveScene3DEvent.OBJECT_OVER, onPlaneRollOver );
				currentPlane = null; 
				scene.removeChild(scene.getChildByName("plane" + index));
				scene.addChild(p, "plane" + index);
								
				// interactive
				p.addEventListener( InteractiveScene3DEvent.OBJECT_RELEASE, onPlaneRelease, false, 0, true );
				p.addEventListener( InteractiveScene3DEvent.OBJECT_OVER, onPlaneRollOver, false, 0, true );
				p.addEventListener( InteractiveScene3DEvent.OBJECT_OUT, onPlaneRollOut, false, 0, true );
				currentPlane = p;
				renderer.renderScene(scene, camera, viewport);
				
				// add to display list
				largeItem[index].visible = true;
				largeItem[index].alpha = 0;
				removeChild(thumbnailNav);
				removeChild(navMode);
				addChild(largeItem[index]);
				addChild(thumbnailNav);
				addChild(navMode);
					
				// display large item
				if (!navigationMode)
				{
					largeItem[index].x = (stage.stageWidth - largeItem[index].width) / 2;
					largeItem[index].y = (stage.stageHeight - largeItem[index].height) / 2;
					Tweener.addTween(largeItem[index],	{	alpha:1,
															time:1
														}
									);		
				}
				else
				largeItem[index].x = stage.stageWidth;
				
				// add interactive on large item
				largeVersion.addEventListener(MouseEvent.MOUSE_OVER, itemRollOver);
				largeVersion.addEventListener(MouseEvent.MOUSE_OUT, itemRollOut);
				largeVersion.addEventListener(MouseEvent.MOUSE_DOWN, itemPress);
			}
					
		}
		
		//____________________________________________________ LARGE ITEM ROLL OVER ROLL OUT
		
		private function itemRollOver(e:Event):void
		{
			buttonMode = true;
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			var description:TextField = thumbnailNav.thumbnailArea.description;
			description.htmlText = desc[currentItem];
			// pull thumbnail area down
			Tweener.addTween(area,	{	y:thumbnailNav.controlLeft.height,
										time:descriptionTweenTime,
										transition:descriptionTweenEasing
									}
								);
			// show description
			Tweener.addTween(description,	
									{	y:thumbnailNav.controlLeft.height - description.height,
										time:descriptionTweenTime,
										transition:descriptionTweenEasing
									}
								);
								
		}
		
		private function itemRollOut(e:Event):void
		{
			buttonMode = false;
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			var description:TextField = thumbnailNav.thumbnailArea.description;
			// pull thumbnail area up 
			Tweener.addTween(area,	{	y:0,
										time:1,
										transition:"easeOutQuint"
									}
								);
			// hide description
			Tweener.addTween(description,	
									{	y: -description.height,
										time:1,
										transition:"easeOutQuint"
									}
								);
		}
		
		private function itemPress(e:Event):void
		{
			// Open link 
			if (link[currentItem] != null)
			{
				var myURL:URLRequest = new URLRequest(link[currentItem]);
				navigateToURL(myURL, openType);
			}
		}
		
		
		
		//_________________________________________________ MOUSE WHEEL / ZOOM FUNCTION
		
		// setup mousewheel handler
		private function setupMouseWheel():void
		{
			stage.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
		}
		
		// remove mousewheel handler
		private function removeMouseWheel():void
		{
			stage.removeEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
		}
		
		// MouseWheel handler
		private function mouseWheelHandler(e:MouseEvent):void
		{
			this.removeEventListener(Event.ENTER_FRAME, update3D);
			
			var DELTA:Number = Math.round(e.delta / 3);
			
			// new camera Radius
			cameraRadius += DELTA * zoomRate;
			var x = Math.cos(angle * Math.PI/180) * cameraRadius;
			var z = Math.sin(angle * Math.PI/180) * cameraRadius; 
			
			Tweener.addTween(camera,	{	x:x,
											z:z,
											time:zoomTweenTime,
											transition:zoomTweenEasing,
											onUpdate:function():void
											{
												camera.lookAt(new DisplayObject3D(null, null, {x:0, y:0, z:0}));
												// Render 3D
												renderer.renderScene(scene, camera, viewport);
											},
											onComplete:function():void
											{
												addEventListener(Event.ENTER_FRAME, update3D);
											}
										}
								);
		}
		
		
		//_________________________________________________ CAMERA NAVIGATION
		
		private function setupStageMouseDown():void
		{
			stage.addEventListener(MouseEvent.MOUSE_DOWN, stagePress);
		}
		
		private function stagePress(e:Event):void
		{
		 	if (navigationMode)
		 	{
			 	// Zoom mode turn back to original position
			 	if (zoomMode && !rollOver)
			 	{
			 		angle = 0;
			 		zoomMode = false;
			 		Tweener.addTween(camera,{	x:cameraRadius,
			 									y:cameraY,
			 									z:0,
			 									time:2,
			 									transition:"easeOutQuint",
			 									onUpdate:function():void
			 									{
			 										camera.lookAt(hotSpot);
			 										renderer.renderScene(scene, camera, viewport);
			 									},
			 									onComplete:function():void
			 									{
			 										addEventListener(Event.ENTER_FRAME, update3D);
			 									}
			 								}
			 								);
			 								
			 		Tweener.addTween(hotSpot,{	x:0,
			 									y:0,
			 									z:0,
			 									time:2,
			 									transition:"easeOutQuint"
			 								}
			 								);	
			 	} 
			 	else
			 	// display camera navigation
			 	if (!rollOver)
			 	{
					mouseX0 = stage.mouseX;
					mouseY0 = stage.mouseY;
					cameraX0 = camera.x;
					cameraY0 = camera.y;
					this.removeEventListener(Event.ENTER_FRAME, update3D);
					stage.addEventListener(MouseEvent.MOUSE_UP, stageUp);
					stage.addEventListener(MouseEvent.MOUSE_MOVE, stagePressMove);
			 	}
		 	}
		}
		
		private function stageUp(e:Event):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, stagePressMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, stageUp);
			cameraRadius = Math.sqrt(camera.x * camera.x + camera.z * camera.z);
			angle = Math.acos(camera.x / cameraRadius) * 180 / Math.PI;
			addEventListener(Event.ENTER_FRAME, update3D);
		}
		
		private function stagePressMove(e:Event):void
		{
			var deltaX:Number = stage.mouseX - mouseX0;
			var deltaY:Number = stage.mouseY - mouseY0;
			camera.lookAt(new DisplayObject3D(null, null, {x:0, y:0, z:0}));
			camera.x = cameraX0 + deltaX;
			camera.y = cameraY0 + deltaY;
			renderer.renderScene(scene, camera, viewport);
		}
		
		
		//_________________________________________________ SET UP THUMBNAIL AREA
		
		private function setUpThumbnailArea():void
		{
			// retrieve thumbnail area
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			thumbnailLength = area.width - 2 * thumbnailNav.controlLeft.width;
			thumbnailNum = Math.floor(thumbnailLength / thumbnailSize);
			thumbnailDistance = Math.round((thumbnailLength - thumbnailNum * thumbnailSize) / (thumbnailNum + 1));
			thumbnailMove = thumbnailNum * (thumbnailDistance + thumbnailSize);
		}
		
		
		//_________________________________________________ GALLERY MODE
		
		private function displayGalleryMode(index:Number):void
		{
			navigationMode = false;
			
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, stagePress);
			
			// Fade out viewport, caption, disable interactive
			viewport.interactive = false;
			Tweener.addTween([viewport, caption, clickToActive],
								{	alpha:0,
									time:0.5,
									onComplete:function():void
									{
										caption.x = stage.stageWidth - caption.width;
										caption.y = stage.stageHeight - caption.height;
										removeChild(viewport);
										removeChild(caption);
										removeChild(clickToActive);
									}
								}
								);
			
			largeItem[index].visible = true;
			largeItem[index].x = (stage.stageWidth - largeItem[index].width) / 2;
			largeItem[index].y = (stage.stageHeight - largeItem[index].height) / 2;
			Tweener.addTween(largeItem[index],	{	alpha:1,
													time:1
												}
							);
							
			// Show Thumbnail Area
			var targetY:Number = thumbnailNav.height - thumbnailNav.thumbnailArea.description.height;
			thumbnailNav.x = (stage.stageWidth - thumbnailOrigin) * .5;
			Tweener.addTween(thumbnailNav,
										{	y:stage.stageHeight - targetY,
											time:1,
											onUpdate:function():void
											{
												thumbnailBack.y = thumbnailNav.y;
											}
										}
									);
			
			
							
			// Fade in mode button
			Tweener.addTween(navMode,
										{	alpha:1,
											time:1
										}
									);
		}
		
		//_________________________________________________ THUMBNAIL AREA INTERACTIVE
		
		private function addThumbnailAreaInteractive():void
		{
			var cLeft:MovieClip = thumbnailNav.controlLeft.arrowBut;
			var cRight:MovieClip = thumbnailNav.controlRight.arrowBut;
			cLeft.buttonMode = cRight.buttonMode = true;
			cLeft.addEventListener(MouseEvent.MOUSE_DOWN, controlLeftPress);
			cRight.addEventListener(MouseEvent.MOUSE_DOWN, controlRightPress);
		}
		
		
		private function controlLeftPress(e:Event):void
		{
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			step = (step > 0) ? (--step) : (step);
			var target:Number = -step * thumbnailMove;
			Tweener.addTween(area,	{	x:	target,
										time:thumbnailTweenTime,
										transition:thumbnailTweenEasing
									}
								);	
		}
		
		private function controlRightPress(e:Event):void
		{
			var area:MovieClip = thumbnailNav.thumbnailArea.area;
			step = (step < thumbnailStep - 1) ? (++step) : (step);
			var target:Number = -step * thumbnailMove;
			if (step == thumbnailStep - 1) target += remain;
			Tweener.addTween(area,	{	x:	target,
										time:thumbnailTweenTime,
										transition:thumbnailTweenEasing
									}
								);
		}
		
		//_________________________________________________ MODE BUTTON INTERACTIVE
		
		private function setUpModeButton():void
		{
			navMode.alpha = 0;
			navMode.buttonMode = true;
			
			// Add interactive
			navMode.addEventListener(MouseEvent.MOUSE_DOWN, navModePress);
		}
		
		private function navModePress(e:Event):void
		{
			navigationMode = true;
			currentPlane = null;
			
			// Move Camera Back
			angle = 0;
			hotSpot.x = hotSpot.y = hotSpot.z = 0;
			camera.x = cameraRadius;
			camera.y = cameraY;
			camera.z = 0;
			camera.lookAt(hotSpot);
			renderer.renderScene(scene, camera, viewport);
			
			// Fade in viewport, caption, enable interactive
			addChild(viewport);
			Tweener.addTween([viewport, caption, clickToActive],
								{	alpha:1,
									time:0.5,
									onComplete:function():void
									{
										viewport.interactive = true;
										addEventListener(Event.ENTER_FRAME, update3D);
									}
								}
								);
								
			// hide Thumbnail Area
			Tweener.addTween(thumbnailNav,
										{	y:stage.stageHeight,
											time:1,
											onUpdate:function():void
											{
												thumbnailBack.y = thumbnailNav.y;
											}
										}
									);
									
			// hide large item
			Tweener.addTween(largeItem[currentItem],	
												{	alpha:0,
													time:0.5,
													onComplete:function():void
													{
														// put them outside
														for (var i:uint = 0; i < TOTAL; i++)
														if (largeItem[i] != null)
															largeItem[i].x = stage.stageWidth;	
													}
												}
							);
							
			// Fade out mode button
			Tweener.addTween(navMode,
										{	alpha:0,
											time:1
										}
									);
			
			// Add clickToActive, caption
			addChild(caption);
			addChild(clickToActive);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, stagePress);
		}
		
		//___________________________________________________________ PRELOADING
		
		// Small item and thumbnail
		private function preload(e:Event):void
		{
			var preloader = e.target;
			var bar = preloader.process;
			bar.scaleX += ((count + count0) / (2 * TOTAL) - bar.scaleX) * 0.1;
			
			if (bar.scaleX >= 0.95) {
				
				bar.scaleX = 1;
				viewport.visible = true;
				
				//Fade out preloader
				Tweener.addTween( preloader, {	alpha:0, 
								 				time:1, 
												onComplete:function():void {
													
													//remove preloader ~ load complete
													removeChild(preloader)
													
													// fade in screen, scroller, caption, tooltip
													Tweener.addTween([viewport], 
																		{	alpha:1, 
																			time:1,
																			onComplete:function():void
																			{
																				caption.visible = true;
																			}
																			});
												}
												});
				
				// remove Enterframe event for preloader
				preloader.removeEventListener(Event.ENTER_FRAME, preload);
			}
		}
		
		private function preloadLarge(e:Event):void
		{
			preloader.process.scaleX += (bytesLoaded / bytesTotal - preloader.process.scaleX) * 0.1;	
		}
		
		// Large Item
		private function loadingLargeVersion(e:Event):void
		{
			bytesLoaded = e.target.bytesLoaded;
			bytesTotal = e.target.bytesTotal;
		}
		
		//__________________________________________ APPLY STYLE SHEET
			
		private function initStyleSheet():void
		{
			// load external css
			var req:URLRequest = new URLRequest(css_path);
			var loader:URLLoader = new URLLoader();
			loader.load(req);
			loader.addEventListener(Event.COMPLETE, cssLoaded);
		}
		
		private function cssLoaded(e:Event):void
		{
			css.parseCSS(e.target.data);
			thumbnailNav.thumbnailArea.description.styleSheet = css;
		}
		
		//__________________________________________ REPOSITION
		
		private function rePosition(e:Event):void
		{
			// thumbnail Area
			thumbnailNav.x = (stage.stageWidth - thumbnailOrigin) * .5;
			thumbnailBack.width = stage.stageWidth;
		}
		
		//_________________________________________ RENDER 3D ON ENTERFRAME
		
		private function update3D(e:Event):void
		{
			var del:Number = (stage.mouseX - stage.stageWidth * 0.5) * .002;
			angle += del;
			
			var x = Math.cos(angle * Math.PI/180) * cameraRadius;
			var z = Math.sin(angle * Math.PI/180) * cameraRadius;
			camera.x = x;
			camera.z = z;
						
			camera.lookAt(hotSpot);
			
			// Render 3D
			renderer.renderScene(scene, camera, viewport);
		}
		
	}
}
